<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    * Classe per gestire i Documenti contabili
    * 
    * in Geecom abbiamo 4 tipi di documenti contabili:
    *  - preventivi
    *  - fatture 
    *  - riceveute
    *  - voci prima nota
    */

    class DocumentoContabile {
        private $db;
        private $id;
        private $idUtente;
        private $numeroDocumento;
        private $tipo;
        private $entrataUscita;
        private $etichetta;
        private $numero;
        private $oggetto;
        private $testo;
        private $imponibile;
        private $iva;
        private $totale;
        private $metodoPagamento;
        private $stato;
        private $giorniNecessari;
        private $giorniValidita;
        private $dataEmissione;
        private $dataPagamento;
        private $dataAccettazione;
        
        public function __construct($db, $id, $idUtente=0, $tipo="", $entrataUscita="", $etichetta = "", $numero=0, $oggetto="", $testo="", $imponibile=0, $iva=0, $totale=0, $metodoPagamento="", $stato="", $giorniNecessari=0, $giorniValidita=0, $dataEmissione="", $dataPagamento="", $dataAccettazione="") {
            $this->db            = $db;
            $this->id            = $id;
            $this->idUtente      = $idUtente;
            $this->tipo          = $tipo;
            $this->entrataUscita = $entrataUscita;
            $this->etichetta     = $etichetta;
            $this->numero        = $numero;
            $this->oggetto       = $oggetto;
            $this->testo         = $testo;
            $this->imponibile    = $imponibile;
            $this->iva           = $iva;
            $this->totale        = $totale;
            $this->metodoPagamento  = $metodoPagamento;
            $this->stato            = $stato;
            $this->giorniNecessari  = $giorniNecessari;
            $this->giorniValidita   = $giorniValidita;
            $this->dataEmissione    = $dataEmissione;
            $this->dataPagamento    = $dataPagamento;
            $this->dataAccettazione = $dataAccettazione;
        }

        public function crea() {
            $data  = date("Y-m-d H:i");
            $dataPagamento = ($this->dataPagamento!="") ? "'$this->dataPagamento'" : "NULL";
            $query = "INSERT INTO `geecAd_documentiContabili` (`id`, `numeroDocumento`, `idUtente`, `tipo`, `entrataUscita`, `etichetta`, `numero`, `oggetto`, `testo`, `imponibile`, `iva`, `totale`, `metodoPagamento`, `stato`, `giorniNecessari`, `giorniValidita`, `dataEmissione`, `dataPagamento`)
                        VALUES (NULL, 0, '$this->idUtente', '$this->tipo', '$this->entrataUscita', '$this->etichetta', '$this->numero', '$this->oggetto', '$this->testo', '$this->imponibile', '$this->iva', '$this->totale', '$this->metodoPagamento', '$this->stato', '$this->giorniNecessari', '$this->giorniValidita', '$data', $dataPagamento)";
            $this->id = $this->db->eseguiQueryCreazione($query);
            
            $this->assegnaNumero();
            return $this->id;
        }
        
        public function modifica() {
            $stringaModificaDataPagamento = ($this->dataPagamento!="") ? ", dataPagamento='$this->dataPagamento' " : "";
            $query = "UPDATE`geecAd_documentiContabili` SET idUtente='$this->idUtente', tipo='$this->tipo', entrataUscita='$this->entrataUscita', etichetta='$this->etichetta', numero='$this->numero', oggetto='$this->oggetto', testo='$this->testo', imponibile='$this->imponibile', iva='$this->iva', totale='$this->totale', metodoPagamento='$this->metodoPagamento', stato='$this->stato', giorniNecessari='$this->giorniNecessari', giorniValidita='$this->giorniValidita' $stringaModificaDataPagamento WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        public function elimina() {
            $this->db->eseguiQueryCancellazione("geecAd_documentiContabili",$this->id);
        }
        
        public function duplica() {
            $data  = date("Y-m-d H:i");
            
            // Inizializzo adesso la query per le voci documento, prima che venga cambiato l'id
            $queryVociDocumento = "SELECT * FROM geecAd_vociDocumentiContabili WHERE idDocumento=$this->id";
            
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geecAd_documentiContabili WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geecAd_documentiContabili SELECT * FROM tabella_temporanea;");
            $this->id = $this->db->idUltimoElemento(); // l'id viene modificato con l'id dell'elemento duplicato, per poter eseguire il assegnaNumero()
            $this->db->eseguiQueryScrittura("DROP TABLE tabella_temporanea");
            $this->assegnaNumero();
            
            $queryAggiornamentoData = "UPDATE geecAd_documentiContabili SET dataEmissione='$data', dataPagamento=NULL WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($queryAggiornamentoData);
            
            // eseguo la queru per vedere se ci sono vodi nel documento sorgente, se si le copio nel nuovo
            $risQuery = $this->db->eseguiQueryLettura($queryVociDocumento);
            while($voceDocumento = $risQuery->fetch_assoc()) {
		    $this->aggiungiVoceDocumento(filter_var($voceDocumento["descrizione"],FILTER_SANITIZE_ADD_SLASHES),$voceDocumento["quantita"],$voceDocumento["prezzo"],$voceDocumento["iva"]);
            }
            
            return $this->id;
        }
        
        /*
         * Assegna un numero al documento. Scorre il database per vedere l'ultimo numero occupato di quel tipo di documento
         * e assegna il successivo
         */
        public function assegnaNumero() {
            $annoCorrente = date("Y");
            $queryUltimoDocumento = "SELECT * FROM geecAd_documentiContabili WHERE tipo LIKE '$this->tipo' AND dataEmissione>='{$annoCorrente}-01-01' ORDER BY id DESC";
            $risDocumenti         = $this->db->eseguiQueryLettura($queryUltimoDocumento);
            $numeroDocumenti      = $risDocumenti->num_rows;
            
            if($numeroDocumenti>0) {
                $numeroDocumento = $numeroDocumenti;
            }
            else {
                $numeroDocumento = 1;
            }
            
            $query = "UPDATE`geecAd_documentiContabili` SET numeroDocumento=$numeroDocumento WHERE id=$this->id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        public function caricaDatiDalDatabase() {
            $datiDocumento = $this->db->leggiSingolaRiga("geecAd_documentiContabili",$this->id);
            $this->numeroDocumento  = $datiDocumento["numeroDocumento"];
            $this->idUtente         = $datiDocumento["idUtente"];
            $this->tipo             = $datiDocumento["tipo"];
            $this->entrataUscita    = $datiDocumento["entrataUscita"];
            $this->etichetta        = $datiDocumento["etichetta"];
            $this->numero           = $datiDocumento["numero"];
            $this->oggetto          = $datiDocumento["oggetto"];
            $this->testo            = $datiDocumento["testo"];
            $this->imponibile       = $datiDocumento["imponibile"];
            $this->iva              = $datiDocumento["iva"];
            $this->totale           = $datiDocumento["totale"];
            $this->metodoPagamento  = $datiDocumento["metodoPagamento"];
            $this->stato            = $datiDocumento["stato"];
            $this->giorniNecessari  = $datiDocumento["giorniNecessari"];
            $this->giorniValidita   = $datiDocumento["giorniValidita"];
            $this->dataEmissione    = $datiDocumento["dataEmissione"];
            $this->dataPagamento    = $datiDocumento["dataPagamento"];
            $this->dataAccettazione = $datiDocumento["dataAccettazione"];
        }
        
        public function aggiungiVoceDocumento($descrizione,$quantita,$prezzo,$iva) {
            $totaleParziale = $quantita * $prezzo;
            $query = "INSERT INTO `geecAd_vociDocumentiContabili` (`id`, `idDocumento`, `descrizione`, `quantita`, `prezzo`, `iva`, `totaleParziale`) VALUES (NULL, '$this->id', '$descrizione', '$quantita', '$prezzo', '$iva', '$totaleParziale');";
            $this->db->eseguiQueryCreazione($query);
        }
        
        public function salvaInVociPredefinite($descrizione,$prezzo,$iva) {
            $query = "INSERT INTO `geecAd_vociDocumentiContabiliPredefinite` (`id`, `descrizione`, `prezzo`, `iva`) VALUES (NULL, '$descrizione', '$prezzo','$iva');";
            $this->db->eseguiQueryCreazione($query);
        }
        
        public function aggiornaImportoTotale() {
            $imponibile = 0;
            $iva        = 0;
            
            $queryVoci = "SELECT * FROM `geecAd_vociDocumentiContabili` WHERE idDocumento=$this->id";
            $risVoci   = $this->db->eseguiQueryLettura($queryVoci);
            
            while($voceDocumento = $risVoci->fetch_assoc()) {
            	$imponibileParziale = $voceDocumento["prezzo"] * $voceDocumento["quantita"];
            	$imponibile += $imponibileParziale;
            	
            	if($this->tipo=="fattura" || $this->tipo=="preventivo") { // in questo caso deve calcolare anche l'IVA
			$ivaParziale = $imponibileParziale * $voceDocumento["iva"] / 100;
			$iva += $ivaParziale;
            	}
            }
            
            $totale = $imponibile + $iva;
            $queryVoci = "UPDATE `geecAd_documentiContabili`SET imponibile='$imponibile', iva='$iva', totale='$totale' WHERE id=$this->id";
            $risVoci   = $this->db->eseguiQueryLettura($queryVoci);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getIdUtente() {
            return $this->idUtente;
        }

        public function getNumeroDocumento() {
            return $this->numeroDocumento;
        }

        public function getTipo() {
            return $this->tipo;
        }

        public function getEntrataUscita() {
            return $this->entrataUscita;
        }

        public function getEtichetta() {
            return $this->etichetta;
        }

        public function getNumero() {
            return $this->numero;
        }

        public function getOggetto() {
            return $this->oggetto;
        }

        public function getTesto() {
            return $this->testo;
        }

        public function getImponibile() {
            return $this->imponibile;
        }

        public function getIva() {
            return $this->iva;
        }

        public function getTotale() {
            return $this->totale;
        }

        public function getMetodoPagamento() {
            return $this->metodoPagamento;
        }

        public function getStato() {
            return $this->stato;
        }

        public function getGiorniNecessari() {
            return $this->giorniNecessari;
        }

        public function getGiorniValidita() {
            return $this->giorniValidita;
        }

        public function getDataEmissione() {
            return $this->dataEmissione;
        }
        
        public function getDataPagamento() {
            return $this->dataPagamento;
        }

        public function getDataAccettazione() {
            return $this->dataAccettazione;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setIdUtente($idUtente): void {
            $this->idUtente = $idUtente;
        }

        public function setNumeroDocumento($numeroDocumento): void {
            $this->numeroDocumento = $numeroDocumento;
        }

        public function setTipo($tipo): void {
            $this->tipo = $tipo;
        }

        public function setEntrataUscita($entrataUscita): void {
            $this->entrataUscita = $entrataUscita;
        }

        public function setEtichetta($etichetta): void {
            $this->etichetta = $etichetta;
        }

        public function setNumero($numero): void {
            $this->numero = $numero;
        }

        public function setOggetto($oggetto): void {
            $this->oggetto = $oggetto;
        }

        public function setTesto($testo): void {
            $this->testo = $testo;
        }

        public function setImponibile($imponibile): void {
            $this->imponibile = $imponibile;
        }

        public function setIva($iva): void {
            $this->iva = $iva;
        }

        public function setTotale($totale): void {
            $this->totale = $totale;
        }

        public function setMetodoPagamento($metodoPagamento): void {
            $this->metodoPagamento = $metodoPagamento;
        }

        public function setStato($stato): void {
            $this->stato = $stato;
        }

        public function setGiorniNecessari($giorniNecessari): void {
            $this->giorniNecessari = $giorniNecessari;
        }

        public function setGiorniValidita($giorniValidita): void {
            $this->giorniValidita = $giorniValidita;
        }

        public function setDataEmissione($dataEmissione): void {
            $this->dataEmissione = $dataEmissione;
        }

        public function setDataPagamento($dataPagamento): void {
            $this->dataPagamento = $dataPagamento;
        }
        
        public function setDataAccettazione($dataAccettazione): void {
            $this->dataAccettazione = $dataAccettazione;
        }
    }
